<?php
include_once 'db.php';
session_start();

header('Content-Type: application/json');

// Retrieve and decode JSON input
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody, true);

// Extract the purchase ID from the decoded data
$purchaseid = $data['purchase_id'] ?? ''; 

if (empty($purchaseid)) {
    echo json_encode(['error' => 'purchase ID is required']);
    exit();
}

// Query to fetch purchase data
$purchaseDataQuery = "SELECT * FROM purchase_data WHERE purchase_id = '$purchaseid' AND Delete_status = 0";
$purchaseDataResult = mysqli_query($conn, $purchaseDataQuery);

if (!$purchaseDataResult) {
    echo json_encode(['error' => 'Failed to fetch purchase data: ' . mysqli_error($conn)]);
    exit();
}

$purchases = [];

while ($row = mysqli_fetch_assoc($purchaseDataResult)) {
    $productid = $row['Product_id'];
    $productQuery = "SELECT Product_id, Product_name,Product_image FROM product WHERE Product_id = '$productid' AND Delete_status = 0";
    $productResult = mysqli_query($conn, $productQuery);

    if (!$productResult) {
        echo json_encode(['error' => 'Failed to fetch product data: ' . mysqli_error($conn)]);
        exit();
    }

    $product = mysqli_fetch_assoc($productResult);
    $productname = $product['Product_name'] ?? 'Unknown Product';
    $productimage = $product['Product_image']?? '';

    // Add purchase data to the array
    $purchases[] = [
        'productid' => $productid,
        'productname' => $productname,
        'productimage' => $productimage,
        'mrp' => $row['MRP'],
        'saleprice' => $row['Selling_price'],
        'discountvalue' => $row['discount'],
        'discountpercentage' => $row['Discount_percentage'],
        'qty' => $row['qty'],
        'amount' => $row['Product_total'],
        'taxvalue' => $row['Tax'],
        'taxpercentage' => $row['Tax_percentage'],
        'salepricetax' => $row['salepricetax']
    ];
}

// Store the fetched data in the session
$_SESSION['purchase_data'] = $purchases;

echo json_encode(['status' => 'success', 'data' => $purchases]);

// Close the database connection
mysqli_close($conn);
?>
